﻿//////////////////////////////////////////////
// MeshWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkGraphicsWrap
{
	class DLL_ASTRAEUS_EXPORT MeshWrapper final
	{
		public :

			// Environment update
			static void updateEnvironment (nkScripts::Environment* env) ;

			// Callbacks
			// Composition
			static void setCurrentVertexComposition (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getCurrentVertexComposition (void* data) ;
			// Loading
			static nkScripts::OutputValue fillPackedFromUnpacked (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue load (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue unload (const nkScripts::DataStack& stack) ;
			// Vertices
			static nkScripts::OutputValue getNewVertexArray (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getCurrentVertexArray (const nkScripts::DataStack& stack) ;
			static void setVertexCount (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getVertexCount (void* data) ;
			// Indices
			static nkScripts::OutputValue getNewIndexArray (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getCurrentIndexArray (const nkScripts::DataStack& stack) ;
			static void setIndexCount (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getIndexCount (void* data) ;
			// Utilities
			static void setHidden (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getHidden (void* data) ;
			static nkScripts::OutputValue getLoadState (void* data) ;
	} ;
}